@echo off
setlocal

IF "%~1"=="" (
    echo [41mNo cooked directory was provided[0m
    pause
    goto :eof
)

echo %~1

set targetFilename="%~1.utoc"
set metadataDirectory="%~dp0Metadata"
set commandsFilename="%~dp0Metadata\IoStoreCommands.txt"
set cryptoFilename="%~dp0Metadata\Crypto.json"
set paksDirectoryFilename="%~dp0paks_directory.txt"

rem Read paks directory, needed for global.utoc and moving utoc/ucas to Paks dir
IF NOT EXIST %paksDirectoryFilename% (
    echo [41mFailed to find 'paks_directory.txt'[0m
    pause
    goto :eof
)
set /p paksDirectory=<%paksDirectoryFilename%

set globalUtocFilename="%paksDirectory%\global.utoc"
set scriptObjectsFilename="%~dp0Metadata\scriptobjects.bin"

IF EXIST %globalUtocFilename% (
    echo [32mUsing script objects from global container %globalUtocFilename%[0m
    set scriptObjectsArg=%globalUtocFilename%   
) ELSE (
    echo [41mFailed to find global container 'global.utoc'. Make sure 'gamepath.txt' is valid[0m
    pause
    goto :eof
)

rem Generate IoStore Container
"Engine\Binaries\Win64\UnrealPak.exe" IoStore -Target=%targetFilename% -CookedDirectory="%~1" -DoNotUsePackageStoreManifest -Commands=%commandsFilename% -CreateResponse -GlobalContainer=%globalUtocFilename% -ScriptObjects=%scriptObjectsFilename% -patchpaddingalign=2048 -compressionformats=Oodle -compressmethod=Kraken -compresslevel=4 -cryptokeys=%cryptoFilename% -compressionMinBytesSaved=1024 -compressionMinPercentSaved=5 -WriteBackMetadataToAssetRegistry=Disabled -sign -encrypt
if %ERRORLEVEL% NEQ 0 (
    pause
    goto :eof
)

rem Generate Pak File
"Engine\Binaries\Win64\UnrealPak.exe" "%~1.pak" -CookedDirectory="%~1" -CreateResponse -create=%metadataDirectory% -compressionformat=Oodle -cryptokeys=%cryptoFilename% -encrypt
if %ERRORLEVEL% NEQ 0 (
    pause
    goto :eof
)

move "%~1.pak" "%paksDirectory%"
move "%~1.utoc" "%paksDirectory%"
move "%~1.ucas" "%paksDirectory%"
